Unit TwLaunch;
{
Copyright (C) 1993 by David Myers.  All rights reserved.  Personal
copying and use of this code permitted.  This source cannot be
sold or distributed for more than the cost of media.
}

interface
uses
  Crt,FlyCom,FParser,TwScr,FlyMenu,TwAnsi,TwLine;

const
  MaxSectors = 5000;
type
  DistType = RECORD
    Sector, Distance : Integer;
  END;
  SectorArray = ARRAY[1 .. MaxSectors] of byte;
  IntArray = ARRAY[1 .. MaxSectors] of integer;
  MaxDistType = ARRAY[ 1 .. 25] of DistType;
var
  MySectors : SectorArray;
  ExtremeSectors : IntArray;
  MaxExtreme : integer;
  CurrExtreme : integer;
  MaxDist : integer;
  CapFileOpen : boolean;
  MaxDistArray : MaxDistType;

Procedure SaveCapFile;

Procedure LaunchStuff;

implementation
var
  iii : integer;
  ECap : text;

FUNCTION isdigit( var c : char) : boolean;
{ If the character is a digit, returns TRUE, otherwise returns FALSE }
BEGIN
  If ((c >= '0') and (c <= '9')) THEN
    isdigit := TRUE
  ELSE isdigit := FALSE;
END;


Procedure FindUnknownSectors;
var
  i,ec1 : integer;
  tokstr, tok2, S : string;
  P : ParseType;
  toks : integer;
  Loopit : Boolean;
  temp1, temp2, temp3 : Boolean;

BEGIN
  NormalVideo;
  tokstr := ' ' +#8+#9+#10+#13;
  tok2 := tokstr + '[';
  Loopit := TRUE;
  for i := 1 to MaxSectors do
    MySectors[i] := 0;
  Async_Send('C');
  REPEAT
    GetALine(toks,tokstr,S,'?',P,Loopit);
  UNTIL ((NOT Loopit) or MatchToken(P.s[toks-1],'?'));
  If Loopit then begin
    Async_Send('K');
    REPEAT
      GetALine(toks,tokstr,S,')',P,Loopit);
    UNTIL ((NOT Loopit) or MatchToken(P.s[toks-1],'(E/U)'));
    if Loopit then begin
      Async_Send('U');
      Async_Send(#13);
      REPEAT
        GetALine(toks,tok2,S,' ]?',P,Loopit);
        if Matchtoken(P.s[toks-1],'Pause]') then
          Async_Send(#13);

        If (toks > 0) and isdigit(P.s[0][1]) then begin
          Val(P.s[0],i,ec1);
          if (ec1 = 0) and (i > 0) and (i <= UniverseSize) then
             MySectors[i] := 1;
        end;
      UNTIL ((NOT Loopit) or MatchToken(P.s[toks-1],'?'));
      Async_Send('Q');
    end;
  end;

END;

Procedure DisplayStuff;
var
X,Y,YY,j : integer;
c : char;
BEGIN
  SaveScreen(X,Y);
  SelectWindow(1);
  TextColor(Yellow);
  TextBackground(Blue);
  ClrScr;
  Write(' UNKNOWN SECTOR DISPLAY ');
  SelectWindow(2);
  ClrScr;
  j := 0;
  While (j < UniverseSize) do begin
    Inc(j);
    If MySectors[j] > 0 then begin
      Write(j : 4);
      YY := WhereY;
      if YY > 21 then begin
        PressEnter(c);
        if c = #27 then j := MaxSectors+1;
        ClrScr;
      end;
    end;
  end;
  PressEnter(c);
  RestoreScreen;
  NormalVideo;
  GotoXY(X,Y);
END;

Procedure LoadExtreme;
label
  ExtExit;
var
  S,SS : string;
  C : char;
  io,j,X,Y : integer;
  F : text;

BEGIN
  TextColor(White);
  TextBackGround(Blue);
  SaveScreen(X,Y);
  SelectWindow(1);
  ClrScr;
  Write(' === ALT-L -- Load Extreme Sectors Routine === ');
  SelectWindow(2);
  TextColor(LightRed);
  TextBackground(Black);
  ClrScr;
  WriteLn;
  WriteLn(' Name of File To Be Loaded?');
  BuildString(S);
  If S <> '' then begin
    REPEAT
      Assign(F,S);
      {$I-} Reset(F); {$I+}
      io := ioresult;
      if io <> 0 then begin
        WriteLn(' Invalid Filename.  New Name for Extreme Sector File?');
        BuildString(S);
        If S = '' then
          Goto ExtExit;
      end
    UNTIL (io = 0);
    MaxExtreme := 0;
    CurrExtreme := 1;
    REPEAT
      ReadLn(F,j);
      Inc(MaxExtreme);
      ExtremeSectors[MaxExtreme] := j;
    UNTIL EOF(F);
    Close(F);
  end;
ExtExit:
  NormalVideo;
  RestoreScreen;
  GotoXY(X,Y);
END;

Procedure SaveExtreme;
label
  ExtExit;
var
  S,SS : string;
  C : char;
  io,j,X,Y : integer;
  F : text;

BEGIN
  TextColor(White);
  TextBackGround(Blue);
  SaveScreen(X,Y);
  SelectWindow(1);
  ClrScr;
  Write(' *** ALT-L -- Save Extreme Sectors Routine *** ');
  SelectWindow(2);
  TextColor(LightRed);
  TextBackground(Black);
  ClrScr;
  WriteLn;
  WriteLn(' Name of File To Be Saved?');
  BuildString(S);
  If S <> '' then begin
    REPEAT
      Assign(F,S);
      {$I-} Rewrite(F); {$I+}
      io := ioresult;
      if io <> 0 then begin
        WriteLn(' Invalid Filename.  New Name for Extreme Sector File?');
        BuildString(S);
        If S = '' then
          Goto ExtExit;
      end
    UNTIL (io = 0);

    If CurrExtreme < MaxExtreme then
      For j := CurrExtreme to MaxExtreme do
        WriteLn(F,ExtremeSectors[j]:4);
    Close(F);
  end;
ExtExit:
  NormalVideo;
  RestoreScreen;
  GotoXY(X,Y);
END;

Procedure DisplayExtreme;
var
X,Y,YY,j : integer;
c : char;
BEGIN
  SaveScreen(X,Y);
  SelectWindow(1);
  TextColor(Yellow);
  TextBackground(Blue);
  ClrScr;
  Write(' EXTREME SECTOR DISPLAY ');
  SelectWindow(2);
  ClrScr;
  j := CurrExtreme - 1;
  While (j < MaxExtreme) do begin
    Inc(j);
    Write(ExtremeSectors[j] : 4);
    YY := WhereY;
    if YY > 21 then begin
      PressEnter(c);
      if c = #27 then j := MaxSectors+1;
      ClrScr;
    end;
  end;
  PressEnter(c);
  RestoreScreen;
  NormalVideo;
  GotoXY(X,Y);
END;

Procedure LaunchEprobe;
type
  PortType = RECORD
    Sector, Class : integer;
  END;
  PortList = ARRAY[1 .. 500] of PortType;
  PlanetList = ARRAY[1 .. 100] of integer;
  SectorArray = ARRAY[1 .. 26] of String;
var
 SA : SectorArray;
 tokstr,inputstr,S : string;
 index,count,oldcount : integer;
 i,X,Y,YY,low,high,xlow,xhigh,toks,ec1,ec2,temp : integer;
 P : ParseType;
 Planets, ProbeDeath : Planetlist;
 Ports : PortList;
 planetcount, portcount, probedeathcount, currentsector : integer;
 Loopit, isClassZero,isSeen,AlienFlag : Boolean;
 F : text;

BEGIN
  Loopit := TRUE;
  AlienFlag := FALSE;
  SaveScreen(X,Y);
  tokstr := ' '+#8+#9+#10+#13;
  TextColor(LightCyan);
  TextBackGround(Blue);
  WFrameW(10,5,45,20);
  ClrScr;
  WriteLn('Enter Sector Numbers of Probes');
  WriteLn('An Empty Line Quits');
  count := 0;
  REPEAT
    BuildString(S);
    toks := Parse_Str(tokstr,S,P);
    if toks = 3 then begin
      Val(P.s[0],low, ec1);
      Val(P.s[2],high,ec2);
      If ((ec1 = 0) and (ec2 = 0)) then begin
        if low > high then begin
          temp := low;
          low := high;
          high := temp;
        end;
        for i := low to high do begin
          if (count < 25) then begin
            inc(count);
            Str(i,SA[count]);
          end;
        end;
        if (count < 25) then begin
          YY := WhereY;
          GotoXY(12,YY);
          WriteLn(' Count : ',count);
        end
        else WriteLn;
      end;
    end
    else begin
      if toks > 0 then begin
        if ((P.s[0][1] = 'U') or (P.s[0][1] = 'u')) then begin
          low := 1;
          S := '';
          if (toks > 1) then begin
            Val(P.s[1],xlow,ec1);
            if (ec1 = 0) then
              if xlow < UniverseSize then
                low := xlow;
          end;
          for i := low to UniverseSize do begin
            if (MySectors[i] > 0) and (count < 25) then begin
              Inc(count);
              Str(i,SA[count]);
            end;
          end;
          YY := WhereY;
          GotoXY(12,YY);
          WriteLn(' Count : ',count);
        end
        else if ((P.s[0][1] = 'X') or (P.s[0][1] = 'x')) then begin
          oldcount := count;
          i := CurrExtreme;
          S := '';
          { we may want a way to send data from the middle in here }
          While (i <= MaxExtreme) do begin
            if (count < 25) then begin
              Inc(count);
              Str(ExtremeSectors[i],SA[count]);
            end;
            Inc(i);
          end;
          CurrExtreme := CurrExtreme + count - oldcount;
          YY := WhereY;
          GotoXY(12,YY);
          WriteLn(' Count : ',count);
        end
        else if ((P.s[0][1] = 'L') or (P.s[0][1] = 'l')) then begin
          high := MaxDist;
          if (toks = 2) then begin
            Val(P.s[1],xhigh,ec1);
            if (ec1 = 0) then
              if (xhigh > 0) and (xhigh < MaxDist) then
                high := xhigh;
          end;
          if (MaxDist > 0) then
            for i := 1 to high do begin
              if (count < 25) then begin
                Inc(Count);
                Str(MaxDistArray[i].Sector,SA[count]);
              end;
            end;
          YY := WhereY;
          GotoXY(12,YY);
          WriteLn(' Count : ',count);
        end
        else begin
          Inc(count);
          SA[count] := S;
          YY := WhereY;
          GotoXY(12,YY);
          WriteLn(' Count : ',count);
        end;
      end
      else WriteLn;
    end;
  UNTIL((S = '') or (count >= 25));
  if (count >= 1) then begin
  for i := 1 to count do begin
    SA[i] := SA[i] + #13;
  end;
  WriteLn('---------------------');
  WriteLn('Final Count = ',count);
  Delay(2000);
  RestoreScreen;
  SelectWindow(1);
  TextColor(White);
  TextBackground(Cyan);
  ClrScr;
  Write(' -----====== ALT-L Eprobe Launch;  Alt-Q Quits =====----- ');
  SelectWindow(2);
  NormalVideo;
  GotoXY(X,Y);
  index := 1;
  planetcount := 0;
  portcount := 0;
  probedeathcount := 0;
  While ((index <= count) and Loopit) do begin
    currentsector := 1;
    Async_Send('E');
    REPEAT
      GetALine(toks,tokstr,inputstr,':',P,Loopit);
    UNTIL ((NOT Loopit) or MatchToken(P.s[toks-1],':'));
    If Loopit then begin
      Delay(1000);
      Async_Send_String(SA[index]);
      Inc(index);
      REPEAT
        GetALine(toks,tokstr,inputstr,'?',P,Loopit);
        If (toks = 5) and MatchToken(P.s[0],'Probe') then begin
          Val(P.s[4],i,ec1);
          if (ec1 = 0) then
            currentsector := i;
        end;
        If MatchToken(P.s[0],'Aliens') or
           MatchToken(P.s[0],'Traders') or
           MatchToken(P.s[0],'Ferrengi') or
           MatchToken(P.s[0],'Federals:') then begin
          if CapFileOpen then
            WriteLn(ECap,'In Sector ',currentsector,' we see ',inputstr);
          AlienFlag := TRUE;
        end
        else begin
          If MatchToken(P.s[0],'Warps') or MatchToken(P.s[0],'Probe') then
            AlienFlag := FALSE;
          If AlienFlag then begin
            if CapFileOpen then
              WriteLn(ECap,inputstr);
          end;
        end;
        If MatchToken(P.s[0],'Ports') then begin
        { if we see a port, note it }
          if portcount < 1 then begin
            ISSEEN := FALSE;
          end
          else begin
          { record new ports only }
            isseen := FALSE;
            for i := 1 to portcount do
              if Ports[i].Sector = currentsector then
                isseen := TRUE;
          end;
          if NOT isseen then begin
            Inc(portcount);
            Ports[portcount].Sector := currentsector;
            Ports[portcount].Class := Ord(P.s[toks-1][1]) - Ord('0');
            If Ports[portcount].Class = 0 then
              if CapFileOpen then
                WriteLn(ECap,'Class 0 Port in ',currentsector);
          end;
        end;
        If MatchToken(P.s[0],'Probe') and MatchToken(P.s[1],'Destroyed!') then begin
        { note any destroyed probes }
          if probedeathcount < 1 then begin
            ISSEEN := FALSE;
          end
          else begin
          { record destruction in new sectors only}
            isseen := FALSE;
            for i := 1 to probedeathcount do
              if ProbeDeath[i] = currentsector then
                isseen := TRUE;
          end;
          if NOT isseen then begin
            Inc(probedeathcount);
            ProbeDeath[probedeathcount] := currentsector;
            if CapFileOpen then
              WriteLn(ECap,'Probe destroyed in sector ',currentsector);
          end;
        end;
        If MatchToken(P.s[0],'Planets') then begin
        { record any planets seen }
          if planetcount < 1 then begin
            ISSEEN := FALSE;
          end
          else begin
            isseen := FALSE;
            for i := 1 to planetcount do
              if Planets[i] = currentsector then
                isseen := TRUE;
          end;
          if NOT isseen then begin
            Inc(planetcount);
            Planets[planetcount] := currentsector;
            if CapFileOpen then
              WriteLn(ECap,'In Sector ',currentsector,' we see ',inputstr);
          end;
        end;
      UNTIL ((NOT Loopit) or MatchToken(P.s[toks-1],'=Help)?'));
    end;
  end;

  if probedeathcount > 0 then begin
    SaveScreen(X,Y);
    TextColor(White);
    TextBackGround(Blue);
    WFrameW(10,5,45,20);
    ClrScr;
    WriteLn('Probes Died in These Sectors: ');
    for i := 1 to probedeathcount do
      WriteLn(ProbeDeath[i]);
    WriteLn('-----------------------');
    WriteLn('Press ENTER to continue');
    ReadLn(S);
    SelectWindow(2);
    RestoreScreen;
    NormalVideo;
    GotoXY(X,Y);
  end;
  if (planetcount > 0) then begin
    SaveScreen(X,Y);
    TextColor(Yellow);
    TextBackGround(Blue);
    WFrameW(10,5,45,20);
    ClrScr;
    WriteLn('Planets Found in These Sectors: ');
    for i := 1 to planetcount do
      WriteLn(Planets[i]);
    WriteLn('-----------------------');
    WriteLn('Press ENTER to continue');
    ReadLn(S);
    SelectWindow(2);
    RestoreScreen;
    NormalVideo;
    GotoXY(X,Y);
  end;
  isClassZero := FALSE;
  if (portcount > 0) then
  for i := 1 to portcount do
    if (Ports[i].Class = 0) then
      isClassZero := TRUE;
  if isClassZero then begin
    SaveScreen(X,Y);
    TextColor(White);
    TextBackGround(Red);
    WFrameW(10,5,45,12);
    ClrScr;
    WriteLn('Class Zero Ports Found: ');
    for i := 1 to portcount do
      if Ports[i].Class = 0 then
        WriteLn(Ports[i].Sector);
    WriteLn('-----------------------');
    WriteLn('Press ENTER to continue');
    ReadLn(S);
    SelectWindow(2);
    RestoreScreen;
    NormalVideo;
    GotoXY(X,Y);
  end;
  end { if count }
  else begin
    RestoreScreen;
    SelectWindow(2);
    NormalVideo;
    GotoXY(X,Y);
  end;
  TopLine;
  SaveScreen(X,Y);
  TextColor(Yellow);
  TextBackground(GREEN);
  GoToXY(10,10);WriteLn('                      ');
  GoToXY(10,11);WriteLn(' Exiting EPROBE Macro ');
  GoToXY(10,12);WriteLn('                      ');
  Delay(2000);
  NormalVideo;
  RestoreScreen;
  GoToXY(X,Y);
END;

Procedure FindMaxDist;
var
  i,j, jj,maxj,X,Y : integer;
  S : string;
  dist,sum : integer;
  c : char;
  toks : integer;
  P : ParseType;
  tokstr : string;
  Loopit,Done : Boolean;
  MyTime : word;
  isAvoid : boolean;

BEGIN
  sum := 0;
  for i := 1 to UniverseSize do
    sum := sum + MySectors[i];
  if (sum = 0) then
    FindUnknownSectors;
  X := WhereX; Y := WhereY;
  SelectWindow(1);
  TextColor(WHITE);
  TextBackGround(Green);
  ClrScr;
  Write(' ===== Finding Longest Eprobe Distances. ALT-Q Quits ===== ');
  SelectWindow(2);
  NormalVideo;
  GotoXY(X,Y);
  for i := 1 to 25 do begin
    MaxDistArray[i].Distance := 0;
    MaxDistArray[i].Sector := 0;
  end;
  Loopit := TRUE;
  tokstr := ' >' +#8+#9+#10+#13;
  j := 0;
  MaxDist := 0;
  Async_Send('C');
  REPEAT
    GetALine(toks,tokstr,S,'?',P,Loopit);
  UNTIL ((NOT Loopit) or MatchToken(P.s[toks-1],'?'));
  While (j < UniverseSize) do begin
    Inc(j);
    If MySectors[j] > 0 then begin
      isAvoid := FALSE;
      Async_Send('F');
      toks := 0;
      MyTime := 30;
      SetTimeOut(MyTime);
      REPEAT
        GetALine(toks,tokstr,S,'?',P,Loopit);
        if (TimedOut(MyTime) and (toks = 0)) then begin
          Alarm;
          Async_Send('F');
          MyTime := 30;
          SetTimeOut(MyTime);
        end;
      UNTIL ((NOT Loopit) or MatchToken(P.s[toks-1],'?'));
      if Loopit then begin
      Async_Send(#13);
      REPEAT
        GetALine(toks,tokstr,S,'?',P,Loopit);
      UNTIL ((NOT Loopit) or MatchToken(P.s[toks-1],'sector?'));
      if Loopit then begin
      Str(j,S);
      S := S + #13;
      Async_Send_String(S);
      REPEAT
        GetALine(toks,tokstr,S,':?',P,Loopit);
        If MatchToken(P.s[toks-1],'Avoids?') then begin
          isAvoid := TRUE;
          Async_Send('N');
        end;
      UNTIL ((NOT Loopit) or MatchToken(P.s[toks-1],'is:') or isAvoid);
      if Loopit then begin
      dist := 0;
      if not isAvoid then
      REPEAT
        GetALine(toks,tokstr,S,' ?',P,Loopit);
        { LastAttr is a global variable created by the ansi driver
          to save the previous screen attributes }
        If isdigit(P.s[0][1]) then
          if ((TextAttr and 15) = LightRed) or
             ((LastAttr and 15) = LightRed) then
            inc(dist);
      UNTIL ((NOT Loopit) or MatchToken(P.s[toks-1],'?'));
      if Loopit then begin { #4 }
      if (dist > 0) then begin
        Done := FALSE;
        if (MaxDist <= 0) then begin
          Inc(MaxDist);
          MaxDistArray[1].Distance := dist;
          MaxDistArray[1].Sector := j;
        end
        else if (MaxDist < 25) then begin
          i := 0;
          While ( i < MaxDist) and (NOT Done) do begin
            Inc(i);
            if (dist > MaxDistArray[i].Distance) then begin
              Done := TRUE;
              for jj := MaxDist+1 downto i+1 do begin
                 MaxDistArray[jj].Distance := MaxDistArray[jj-1].Distance;
                 MaxDistArray[jj].Sector := MaxDistArray[jj-1].Sector;
              end;
              MaxDistArray[i].Distance := Dist;
              MaxDistArray[i].Sector := j;
              Inc(MaxDist);
            end;
          end;
          if NOT Done then begin
             Inc(MaxDist);
             MaxDistArray[MaxDist].Distance := Dist;
             MaxDistArray[MaxDist].Sector := j;
          end;
        end
        else begin
          i := 0;
          Done := FALSE;
          While ( i < MaxDist) and NOT Done do begin
            Inc(i);
            if dist > MaxDistArray[i].Distance then begin
              Done := TRUE;
              for jj := MaxDist downto i+1 do begin
                 MaxDistArray[jj].Distance := MaxDistArray[jj-1].Distance;
                 MaxDistArray[jj].Sector := MaxDistArray[jj-1].Sector;
              end;
              MaxDistArray[i].Distance := Dist;
              MaxDistArray[i].Sector := j;
              Inc(MaxDist);
            end;
          end;
        end;
      end;
      end; { loopit #4 }
      end; { loopit #3 }
      end; { loopit #2 }
      end; { loopit #1 }
    end;
  end;
  Async_Send('Q');
  TopLine;
  SaveScreen(X,Y);
  TextColor(Yellow);
  TextBackground(Red);
  WFrameW(5,5,45,22);
  ClrScr;
  WriteLn(' The Longest Eprobe Shots Are:');
  If MaxDist > 0 then begin
    maxj := MaxDist;
    if maxj > 12 then maxj := 12;
    for j := 1 to maxj do
      WriteLn('Sector ',MaxDistArray[j].Sector,
              ' Dist: ',MaxDistArray[j].Distance);
  end;
  WriteLn('-----------------');
  WriteLn('Press ENTER ');
  REPEAT
  c := ReadKey;
  UNTIL ((c = #13) or (c = #27));
  RestoreScreen;
  SelectWindow(2);
  NormalVideo;
  GotoXY(X,Y);
END;

Procedure LaunchDisruptors;
var
  toks : integer;
  tokstr,S, sector : string;
  P : ParseType;
  nummines : integer;
  Loopit, Done : Boolean;
  X, Y, index : integer;
BEGIN
  tokstr := ' '+#8+#9+#10+#13;
  SaveScreen(X,Y);
  TextColor(White);
  TextBackground(Blue);
  WFrameW(5,5,45,10);
  ClrScr;
  WriteLn(' TWFT Mine Disruptor Launch ');
  Write(' Sector to launch into : ');
  BuildString(sector);
  if (sector <> '') then begin
  WriteLn;
  sector := sector + #13;
  Write(' Number of  disruptors : ');
  ReadLn(nummines);
  RestoreScreen;
  SelectWindow(1);
  TextColor(White);
  TextBackground(Green);
  ClrScr;
  Write(' ----- ===== +++++ Mine Disruptor Macro - ALT-Q quits +++++ ===== ----- ');
  SelectWindow(2);
  NormalVideo;
  GotoXY(X,Y);
  Loopit := TRUE;
  Async_Send('C');
  REPEAT
    GetALine(toks,tokstr,S,'?',P,Loopit);
  UNTIL ((NOT Loopit) or MatchToken(P.s[toks-1],'?'));
  index := 0;
  Done := FALSE;
  While Loopit and (index < nummines) and (NOT Done) do begin
    Inc(index);
    Async_Send('W');
    REPEAT
      GetALine(toks,tokstr,S,'?',P,Loopit);
    UNTIL ((NOT Loopit) or MatchToken(P.s[toks-1],'?'));
    Async_Send('Y');
    if Loopit then begin
      REPEAT
        GetALine(toks,tokstr,S,')',P,Loopit);
      UNTIL ((NOT Loopit) or MatchToken(P.s[toks-1],'quit)'));
      if Loopit then begin
        Async_Send_String(sector);
        REPEAT
          GetALine(toks,tokstr,S,'?',P,Loopit);
          if (toks > 3) then begin
            If MatchToken(P.s[2],'all') then
              Done := TRUE;
            If MatchToken(P.s[2],'no') then
              Done := TRUE;
          end;
        UNTIL ((NOT Loopit) or MatchToken(P.s[toks-1],'?'));
      end;
    end;
  end; { while }
  if Loopit then
    Async_Send('Q');
  TopLine;
  end { if sector <> '' }
  else begin
    RestoreScreen;
    SelectWindow(2);
    NormalVideo;
    GotoXY(X,Y);
  end;
  SaveScreen(X,Y);
  TextColor(Yellow);
  TextBackground(Red);
  GoToXY(10,10);WriteLn('                              ');
  GoToXY(10,11);WriteLn(' Exiting MINE DISRUPTOR Macro ');
  GoToXY(10,12);WriteLn('                              ');
  Delay(2000);
  NormalVideo;
  RestoreScreen;
  GoToXY(X,Y);
END;

Procedure OpenCapFile;
label
  CapExit;
var
  S : string;
  io,X,Y : integer;

BEGIN
  TextColor(White);
  TextBackGround(Blue);
  SaveScreen(X,Y);
  SelectWindow(1);
  ClrScr;
  Write(' === ALT-L -- Open Capture File Routine === ');
  SelectWindow(2);
  TextColor(LightRed);
  TextBackground(Black);
  ClrScr;
  WriteLn;
  WriteLn(' Name of Capture File To Be Opened?');
  BuildString(S);
  If S <> '' then begin
    REPEAT
      Assign(ECap,S);
      {$I-} Rewrite(ECap); {$I+}
      io := ioresult;
      if io <> 0 then begin
        WriteLn(' Invalid Filename.  New Name for Capture File?');
        BuildString(S);
        If S = '' then
          Goto CapExit;
      end
      else CapFileOpen := TRUE;
    UNTIL (io = 0);
  END;
CapExit:
  NormalVideo;
  RestoreScreen;
  GotoXY(X,Y);
END;

Procedure SaveCapFile;
BEGIN
  Close(ECap);
  CapFileOpen := FALSE;
END;

Procedure LaunchStuff;
var
  X,Y : integer;
  c : char;

BEGIN
  SaveScreen(X,Y);
  REPEAT
    TextColor(LightRed);
    TextBackGround(Black);
    ClrScr;
    GotoXy(22,5); Write('Tradewars Freeware Terminal Launch Menu');
    TextColor(Cyan);
    GotoXy(1,10);Write('A. Eprobe Launch                F. Load Extreme Sectors ');
    GotoXy(1,11);Write('B. Collect Unknown Sectors      G. Save Extreme Sectors ');
    GotoXy(1,12);Write('C. Display Unknown Sectors      H. Display Extreme Sectors');
    GotoXy(1,13);Write('D. Find Longest Distances       I. Open Eprobe Cap File');
    GotoXy(1,14);Write('E. Mine Disruptor Launch        J. Save Eprobe Cap File');
    GotoXy(1,15);Write('X. Exit');
    TextColor(LightRed);
    GoToXY(1,16);
    c := ReadKey;
    c := UpCase(c);
    Case c of
      'A' : BEGIN
              RestoreScreen;
              GotoXY(X,Y);
              LaunchEprobe;
              SaveScreen(X,Y);
            END;
      'B' : BEGIN
              RestoreScreen;
              GotoXY(X,Y);
              FindUnknownSectors;
              SaveScreen(X,Y);
            END;
      'C' : BEGIN
              RestoreScreen;
              GotoXY(X,Y);
              DisplayStuff;
              SaveScreen(X,Y);
            END;
      'D' : BEGIN
              RestoreScreen;
              GotoXY(X,Y);
              FindMAxDist;
              SaveScreen(X,Y);
            END;
      'E' : BEGIN
              RestoreScreen;
              GotoXY(X,Y);
              LaunchDisruptors;
              SaveScreen(X,Y);
            END;
      'F' : BEGIN
              RestoreScreen;
              GotoXY(X,Y);
              LoadExtreme;
              SaveScreen(X,Y);
            END;
      'G' : BEGIN
              RestoreScreen;
              GotoXY(X,Y);
              SaveExtreme;
              SaveScreen(X,Y);
            END;
      'H' : BEGIN
              RestoreScreen;
              GotoXY(X,Y);
              DisplayExtreme;
              SaveScreen(X,Y);
            END;
      'I' : BEGIN
              RestoreScreen;
              GotoXY(X,Y);
              OpenCapFile;
              SaveScreen(X,Y);
            END;
      'J' : BEGIN
              RestoreScreen;
              GotoXY(X,Y);
              SaveCapFile;
              SaveScreen(X,Y);
            END;
    else;
    end; { case }
  UNTIL ((c = 'X') or (c = #27));
  RestoreScreen;
  NormalVideo;
  GotoXY(X,Y);
END;



BEGIN { unit initialization code }
  for iii := 1 to MaxSectors do begin
    MySectors[iii] := 0;
    ExtremeSectors[iii] := 0;
  end;
  MaxDist := 0;
  MaxExtreme := 0;
  CurrExtreme := 1;
  CapFileOpen := FALSE;
END.