Program MergeLd;
{
Copyright (C) 1993 by David Myers.  All rights reserved.  Personal
copying and use of this code permitted.  This source cannot be
sold or distributed for more than the cost of media.
}
uses
  Crt,FParser;
label
  MergeExit;
type
  MyArray = ARRAY[1 .. 5000,1 .. 6] of integer;
var
  A : ^MyArray;
  index : integer;
  sector : integer;
  tosector : integer;
  i,j,k,io,ec1 : integer;
  toks : integer;
  tokstr,ptok : string;
  P : ParseType;
  MyName,MyFile,S,Answer : string;
  Done,isSct : boolean;
  USize : integer;
  F : text;

FUNCTION isdigit( var c : char) : boolean;
{ If the character is a digit, returns TRUE, otherwise returns FALSE }
BEGIN
  If ((c >= '0') and (c <= '9')) THEN
    isdigit := TRUE
  ELSE isdigit := FALSE;
END;


BEGIN
  new(A);
  Usize := 1000;
  {
   check to see if universe if larger than 1000 sectors;
   (e.g. MERGELD 2500) if so alter the Usize parameter
  }
  If ParamCount > 0 then begin
    Val(ParamStr(1),Usize,ec1);
    if ec1 <> 0 then
      Usize := 1000;
  end;
  tokstr := ' '+#8+#9+#10+#13;
  for i := 1 to USize do
    for j := 1 to 6 do
      A^[i][j] := 0;
  TextColor(LightCyan);
  TextBackground(Blue);
  ClrScr;
  Gotoxy(22,1);  Write(' MERGE LEVEL DIAGRAMS v1.01 ');
  GotoXy(20,2);Write(' COPYRIGHT (C) 1993 David Myers');
  GotoXy(25,3);     Write(' All Rights reserved. ');
  REPEAT
  GotoXY(1,5);Write(' Enter Level Diagram to be merged:                 ');
  GotoXY(1,6);Write(' An empty line quits.');
  GotoXY(1,7);
  Write('                                           ');
  GotoXY(1,7);
  BuildString(S);
  If S <> '' then begin
    REPEAT
      Assign(F,S);
      {$I-} Reset(F); {$I+}
      io := ioresult;
      if io <> 0 then begin
        GotoXY(1,5); Write(' Invalid Filename.  New Name for Text File?');
        GotoXY(1,7); BuildString(S);
        If S = '' then
          Goto MergeExit;
      end
    UNTIL (io = 0);
  end;
  While (NOT Eof(F)) do begin
    ReadLn(F,S);
    toks := Parse_Str(tokstr,S,P);
    if (toks > 1) then begin
      if Isdigit(P.s[0][1]) then begin
        Val(P.s[0],sector,ec1);
        if (ec1 = 0) then begin
          for j := 1 to toks-1 do begin
            Val(P.s[j],tosector,ec1);
            if (ec1 = 0) then begin
              k := 1;
              Done := FALSE;
              While ((k < 7) and NOT Done) do begin
                if (A^[Sector][k] = 0) then
                  Done := TRUE
                else if (A^[Sector][k] = toSector) then begin
                  Done := TRUE;
                  k := 7;
                end
                else begin
                  Inc(k);
                  if (k > 6) then
                    Done := TRUE;
                end;
              end;
              if (k < 7) then
                A^[Sector][k] := tosector;
            end;
          end;
        end;
      end;
    end;
  end;
  UNTIL (S = '');
MergeExit:
  GotoXY(1,10);
  Write(' AST or SCT report A/s? ');
  TextColor(White);
  ReadLn(Answer);
  If (length(Answer) = 0) or (Answer[1] = 'A') or (Answer[1] = 'a') then
    isSCT := FALSE
  else isSCT := TRUE;
  ptok := ' .'+#8+#9+#10+#13;
  WriteLn;
  Write(' File Name : ');
  BuildString(MyName);
  toks := Parse_Str(ptok,MyName,P);
  if (toks > 0) then
    MyName := P.s[0]
  ELSE MyName := 'MRGDIAG';
  if isSct then begin
    MyFile := MyName + '.SCT';
    Assign(F,MyFile);
    Rewrite(F);
    WriteLn(F);
    WriteLn(F);
    for i := 1 to USize do begin
      Write(F,i:4);
      if (A^[i][1] = 0) then
        WriteLn(F,'    0')
      else begin
        j := 1;
        While (j < 7) and (A^[i][j] <> 0) do begin
          Write(F,A^[i][j]:5);
          Inc(j);
        end;
        WriteLn(F);
      end;
      WriteLn(F);
    end;
    WriteLn(F);
    WriteLn(F);
    WriteLn(F,':');
    Close(F);
  { end of .SCT support }
  end
  else begin
    MyFile := MyName + '.AST';
    Assign(F,MyFile);
    Rewrite(F);
    WriteLn(F,':');
    for i := 1 to USize do begin
      Write(F,i:4);
      if (A^[i][1] = 0) then
        WriteLn(F,'    0')
      else begin
        j := 1;
        While (j < 7) and (A^[i][j] <> 0) do begin
          Write(F,A^[i][j]:5);
          Inc(j);
        end;
        WriteLn(F);
      end;
    end;
    WriteLn(F);
    WriteLn(F,': ENDINTERROG');
    Close(F);
  { end of .AST support }
  end;
  dispose(A);
  WriteLn;
  Writeln('Done!');
  TextColor(WHite);
  TextBackground(Black);
  Delay(1000);
  ClrScr;
END.