Program LdtoCap;
{
Copyright (C) 1993 by David Myers.  All rights reserved.  Personal
copying and use of this code permitted.  This source cannot be
sold or distributed for more than the cost of media.
}
uses
  Crt,FParser;

label
  MergeExit, CaptureEnd;
type
  MyArray = ARRAY[1 .. 5000,1 .. 6] of integer;
var
  A,B : ^MyArray;
  index : integer;
  sector : integer;
  tosector : integer;
  i,j,k,io,ec1 : integer;
  toks : integer;
  tokstr,ptok : string;
  P : ParseType;
  MyName,MyFile,S,Answer : string;
  Done : boolean;
  USize : integer;
  F,G : text;

FUNCTION isdigit( var c : char) : boolean;
{ If the character is a digit, returns TRUE, otherwise returns FALSE }
BEGIN
  If ((c >= '0') and (c <= '9')) THEN
    isdigit := TRUE
  ELSE isdigit := FALSE;
END;


BEGIN
  new(A);
  new(B);
  Usize := 1000;
  {
   check to see if universe if larger than 1000 sectors;
   (e.g. LDTOCAP 2500) if so alter the Usize parameter
  }
  If ParamCount > 0 then begin
    Val(ParamStr(1),Usize,ec1);
    if ec1 <> 0 then
      Usize := 1000;
  end;
  tokstr := ' '+#8+#9+#10+#13;
  ptok := ' .'+#8+#9+#10+#13;
  for i := 1 to USize do
    for j := 1 to 6 do begin
      B^[i][j] := 0;
      A^[i][j] := 0;
    end;
  TextColor(LightCyan);
  TextBackground(Blue);
  ClrScr;
  Gotoxy(20,1);  Write(' Level Diagram Into CAPTURE.TXT v1.01 ');
  GotoXy(20,2);  Write(' COPYRIGHT (C) 1993 David Myers');
  GotoXy(20,3);  Write(' All Rights reserved. ');
  REPEAT
  GotoXY(1,5);Write(' Enter Level Diagram to be merged:                 ');
  GotoXY(1,6);Write(' An empty line quits.');
  GotoXY(1,7);
  Write('                                           ');
  GotoXY(1,7);
  ReadLn(S);
  toks := Parse_Str(tokstr,S,P);
  if toks > 0 then
    S := P.s[0]
  else S := '';
  If S <> '' then begin
    REPEAT
      Assign(F,S);
      {$I-} Reset(F); {$I+}
      io := ioresult;
      if io <> 0 then begin
        GotoXY(1,5); Write(' Invalid Filename.  New Name for Text File?');
        GotoXY(1,7); BuildString(S);
        If S = '' then
          Goto MergeExit;
      end
    UNTIL (io = 0);
  end;
  While (NOT Eof(F)) do begin
    ReadLn(F,S);
    toks := Parse_Str(tokstr,S,P);
    if (toks > 1) then begin
      if Isdigit(P.s[0][1]) then begin
        Val(P.s[0],sector,ec1);
        if (ec1 = 0) then begin
          for j := 1 to toks-1 do begin
            Val(P.s[j],tosector,ec1);
            if (ec1 = 0) then begin
              k := 1;
              Done := FALSE;
              While ((k < 7) and NOT Done) do begin
                if (A^[Sector][k] = 0) then
                  Done := TRUE
                else if (A^[Sector][k] = toSector) then begin
                  Done := TRUE;
                  k := 7;
                end
                else begin
                  Inc(k);
                  if (k > 6) then
                    Done := TRUE;
                end;
              end;
              if (k < 7) then
                A^[Sector][k] := tosector;
            end;
          end;
        end;
      end;
    end;
  end;
  UNTIL (S = '');
  Close(F);
MergeExit:
  GotoXY(1,5);Write(' Enter Capture file to be merged:                  ');
  GotoXY(1,7);
  Write('                                           ');
  GotoXY(1,7);
  ReadLn(S);
  If S = '' THEN
    S := 'CAPTURE.TXT';
  REPEAT
    Assign(F,S);
    {$I-} Reset(F); {$I+}
    io := ioresult;
    if io <> 0 then begin
      GotoXY(1,5); Write(' Invalid Filename.  New Name for Text File?');
      GotoXY(1,7); BuildString(S);
      If S = '' then
        Goto CaptureEnd;
    end
  UNTIL (io = 0);
  toks := Parse_Str(ptok,S,P);
  if (toks > 0) then
    MyName := P.s[0]
  ELSE MyName := 'CAPTURE';
  MyFile := MyName + '.NEW';
  Assign(G,MyFile);
  Rewrite(G);
  REPEAT
    ReadLn(F,S);
    WriteLn(S);
    WriteLn(G,S);
    toks := Parse_Str(tokstr,S,P);
  UNTIL (MatchToken(P.s[0],':'));
  While (NOT Eof(F)) do begin
    ReadLn(F,S);
    WriteLn(S);
    toks := Parse_Str(tokstr,S,P);
    if (toks > 1) then begin
      if Isdigit(P.s[0][1]) then begin
        Val(P.s[0],sector,ec1);
        if (ec1 = 0) then begin
          for j := 1 to toks-1 do begin
            Val(P.s[j],tosector,ec1);
            if (ec1 = 0) then begin
              k := 1;
              Done := FALSE;
              While ((k < 7) and NOT Done) do begin
                if (B^[Sector][k] = 0) then
                  Done := TRUE
                else if (B^[Sector][k] = toSector) then begin
                  Done := TRUE;
                  k := 7;
                end
                else begin
                  Inc(k);
                  if (k > 6) then
                    Done := TRUE;
                end;
              end;
              if (k < 7) then
                B^[Sector][k] := tosector;
            end;
          end;
        end;
      end;
    end;
  end;
  Close(F);

CaptureEnd:

  ClrScr;
  GoToXY(1,5);
  WriteLn('Merging Data');

for sector := 1 to USize do begin
  for j := 1 to 6 do begin
    if A^[sector][j] <> 0 then begin
      tosector := A^[sector][j];
      k := 1;
      Done := FALSE;
      While ((k < 7) and NOT Done) do begin
        if (B^[Sector][k] = 0) then
          Done := TRUE
        else if (B^[Sector][k] = toSector) then begin
          Done := TRUE;
          k := 7;
        end
        else begin
         Inc(k);
          if (k > 6) then
            Done := TRUE;
        end;
      end;
      if (k < 7) then
        B^[Sector][k] := tosector;
    end;
  end;
end;
for i := 1 to USize do begin
  Write(G,i:4);
  if (B^[i][1] = 0) then
    WriteLn(G,'    0')
  else begin
    j := 1;
    While (j < 7) and (B^[i][j] <> 0) do begin
      Write(G,B^[i][j]:5);
      Inc(j);
    end;
    WriteLn(G);
  end;
end;
WriteLn(G);
WriteLn(G,': ENDINTERROG');
Close(G);
  { end of .AST support }
  dispose(A);
  dispose(B);
  WriteLn;
  Writeln('Done!');
  TextColor(WHite);
  TextBackground(Black);
  Delay(1000);
  ClrScr;
END.